# iOS SDK


## 集成步骤

1. 手动导入: 将 `HYTTS.framework` 拖入工程。然后在 `Gneral -> Framewoks, Libraries, and Embedded Content` 下将` HYTTS.framework` 的 `Embed` 改为 `Embed&Sign`。

2. 确保pod引入了 SocketRocket0.6.0、 AFNetworking, SSZipArchive 2.4.3。

###  添加应用相关权限
1.在项目的 `info.plist` 文件中增加 `Privacy - Microphone Usage Description` 以添加麦克风访问权限。


### 调用步骤/示例代码

#### 获取实例

- 获取 `TTS`的实例

```
    TTSParams *params = [[TTSParams alloc] init];
    params.langType = @"";
    [[TTSManger shareInstance] setSdkParams:params]
    [[TTSManger shareInstance] initWithWithAppid:@"" WithAppSecret:@"" WithinitBlock:^(NSError * _Nonnull Error) {
        
        if (Error == nil) {
            NSLog(@"初始化成功");
        }
        
    }];
   
```

#### 授权激活

（1）配置授权参数
|名称|类型|说明|默认值|
|-------|-------|-------|-------|
|online|string|true在线，false 离线|true|



```
    TTSParams *parames = [[TTSManger getTTSManger] getSdkParams];
    params.online = @"true";//在线、离线

```


#### 参数设置
|参数|类型|是否必需|说明|默认值|
|-------|-------|-------|-------|-------|
|text|String|是|待合成文本|必填|
|lang_type|String|是|语种选项|必填|
|voice|String|否|音色选项||
|format|String|否|音频编码格式|pcm|
|sample_rate|Integer|否|音频采样率|24000|
|volume|Integer|否| 音调 [0.1, 3]，默认为1，通常保留一位小数即可|1.0|
|speech_rate|Float|否|语速 [0.2,3]，默认为1，通常保留一位小数即可|1.0|
|pitch_rate|Float|否|语调，[0.1, 3]，默认为1，通常保留一位小数即可|1.0|
|emotion|String|否|情感风格|无|
|silence_duration|Integer|否|句尾静音时长|无|

```

TTSParams *params = [[TTSParams alloc] init]; params.text = @"";
params.langType = @"";
params.format = @"pcm";
params.voice = @"xiaohui";
params.volume = 50;
params.speech_rate = 1;
params.pitch_rate = 0;
params.sample_rate = 16000;
[[TTSManger shareInstance] setSdkParams:params];

```
#### 开始/停止合成

```
TTSParams *parames = [[TTSManger getTTSManger] getSdkParams];
parames.text = @"";
[[TTSManger getTTSManger] onStart];//开始合成
[[TTSManger getTTSManger] onStop]; //停止合成
```

## 状态码表

| 错误码 | 错误消息             | 解决方案                                           |
| ------ | -------------------- | -------------------------------------------------- |
| 110002 | 能力未授权           | 传参改为已授权的能力或联系商务追加AI能力           |
| 110003 | appid过期            | 联系商务增加appid的有效期                          |
| 110004 | 调用超限             | 联系商务增加授权次数                               |
| 110005 | 并发超限             | 联系商务追加并发                                   |
| 300000 | 参数错误             | 检查参数（参数传不是规定的或传错误的或传空字符串） |
| 300001 | 参数缺失             | 缺少必填参数                                       |
| 300004 | 合成文本为空         | 缺少合成文本                                       |
| 300005 | 合成文本长度超限     | 合成语音的文本，长度限制 1024 字节          |
| 300100 | 正在合成，请稍后再试 | 合成完成后在操作                                   |
| 300101 | 正在播放，请稍后再试 | 播放完成后在操作                                   |
